"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const electron_1 = require("electron");
function createLoginWindow(loginCallback) {
    const loginWindow = new electron_1.BrowserWindow({
        width: 300,
        height: 400,
        frame: false,
        resizable: false,
        webPreferences: {
            nodeIntegration: true,
        },
    });
    loginWindow.loadURL(`file://${path.join(__dirname, '..', 'static/login.html')}`);
    electron_1.ipcMain.once('login-message', (event, usernameAndPassword) => {
        loginCallback(usernameAndPassword[0], usernameAndPassword[1]);
        loginWindow.close();
    });
    return loginWindow;
}
exports.createLoginWindow = createLoginWindow;
//# sourceMappingURL=loginWindow.js.map